<?php
/**
 * Módulo Gerencinet Boleto para WHMCS
 * @author		Mauricio Gofas | gofas.net
 * @see			https://gofas.net/?p=7893
 * @copyright	2017 https://gofas.net
 * @license		https://www.gnu.org/licenses/gpl-3.0.pt-br.html
 * @support		https://gofas.net/?p=7856
 * @version		1.0.3
 */

error_reporting( E_ERROR | E_WARNING | E_PARSE );

if(!defined('WHMCS')) { die('Esse arquivo não pode ser acessado diretamente'); }

require __DIR__.'/gofasgerencianetboleto/sdk/vendor/autoload.php'; 
use Gerencianet\Exception\GerencianetException;
use Gerencianet\Gerencianet;
require __DIR__.'/gofasgerencianetboleto/configuration.php';

function gofasgerencianetboleto_link( $params ) {

	if ( stripos($_SERVER['REQUEST_URI'], 'viewinvoice.php') ) {
		
		require __DIR__.'/gofasgerencianetboleto/params.php';

		require __DIR__.'/gofasgerencianetboleto/functions.php';
		
    	$api = new Gerencianet($opt);
		
		// Consulta transações associadas à fatura
		if ( $transID ) {
			$chargeExist = ggnb_detail_charge( $api, $transID, $debug );
			
			$chargeExistID		= (int)$chargeExist['data']['charge_id']; // ID da transação gerada pela fatura
			$chargeExistStatus	= (string)$chargeExist['data']['status'];
			$chargeExistDuedate	= $chargeExist['data']['payment']['banking_billet']['expire_at'];
			
			if ( $chargeExistID === $transID and $chargeExistStatus !== 'canceled' and $chargeExistDuedate >= date('Y-m-d') ) {
			
				$link		= $chargeExist['data']['payment']['banking_billet']['link'];
				$expire_at	= $chargeExistDuedate;
				$barcode	= $chargeExist['data']['payment']['banking_billet']['barcode'];
			
			} 
			elseif ( ( $chargeExistID === $transID and $chargeExistDuedate < date('Y-m-d') ) and !$configurations and !$cancelBillet ) {
				
				// cancela transação gerada anteriormente
				if ($chargeExistStatus !== 'canceled') {
					
					$updateBillet = ggnb_update_billet( $api, $chargeExistID, $billetDuedate, $debug );
					
					// segunda via do boleto com multa e juros
					if ( $updateBillet === 'sucess' ) {
						
						$link		= $chargeExist['data']['payment']['banking_billet']['link'];
						$expire_at	= $billetDuedate;
						$barcode	= $chargeExist['data']['payment']['banking_billet']['barcode'];
				
					} else {
						$error = $updateBillet;
					}
				
				} 

				elseif ( $chargeExistStatus === 'canceled' ) { // ignora transação cancelada
					$chargeID = ggnb_create_charge( $api, $body, $debug); // body
				}
				
				// Definir método de pagamanto e Gerar a Cobrança (retorna link do boleto etc)
				if ( is_int($chargeID) ) {
					$pay_charge	= ggnb_pay_charge( $api, $chargeID, $body2, $debug);

					if ( is_array($pay_charge) ) {
						$link		= $pay_charge['data']['link'];
						$expire_at	= $pay_charge['data']['expire_at'];
						$barcode	= $pay_charge['data']['barcode'];
				
						// Cria transação no whmcs "Boleto gerado aguardando pagamento."
						$addtrans = ggnb_add_trans($userID,$invoiceID,$chargeID,$whmcsAdmin, $api_mode, $debug );

					} elseif( is_string($pay_charge) ) {
						$error = $pay_charge;
					}
	
				} else {
					$error = $chargeID;
				}
				
			
			}
			elseif ( ($chargeExistID === $transID and $chargeExistDuedate < date('Y-m-d') ) and ($configurations or $cancelBillet) ) {
				
				// cancela transação gerada anteriormente
				if ( $chargeExistStatus === 'new' || $chargeExistStatus === 'waiting' || $chargeExistStatus === 'unpaid' ) {
					$cancelCharge = ggnb_cancel_charge( $api, $chargeExistID, $debug );
					
					// segunda via do boleto com multa e juros
					if ( $cancelCharge === 'sucess' ) {
						// Criar transação
						$chargeID = ggnb_create_charge( $api, $body, $debug); // body
				
					} else {
						$error = $cancelCharge;
					}
				
				} 

				elseif ($chargeExistStatus === 'canceled') { // ignora transação cancelada
					$chargeID = ggnb_create_charge( $api, $body, $debug); // body
				}
				
				// Definir método de pagamanto e Gerar a Cobrança (retorna link do boleto etc)
				if ( is_int($chargeID) ) {
					$pay_charge	= ggnb_pay_charge( $api, $chargeID, $body2, $debug);

					if ( is_array($pay_charge) ) {
						$link		= $pay_charge['data']['link'];
						$expire_at	= $pay_charge['data']['expire_at'];
						$barcode	= $pay_charge['data']['barcode'];
				
						// Cria transação no whmcs "Boleto gerado aguardando pagamento."
						$addtrans = ggnb_add_trans($userID,$invoiceID,$chargeID,$whmcsAdmin, $api_mode, $debug );

					} elseif( is_string($pay_charge) ) {
						$error = $pay_charge;
					}
	
				} else {
					$error = $chargeID;
				}
			
			}
		
		} // end if $transID

		elseif ( !$transID ) {
			
			if ($invoiceAmount >= $minimunAmount) {
				// Criar transação
				$chargeID = ggnb_create_charge( $api, $body, $debug); // body
			
				// Definir método de pagamanto e Gerar a Cobrança (retorna link do boleto etc)
				if ( is_int($chargeID) ) {
					$pay_charge	= ggnb_pay_charge( $api, $chargeID, $body2, $debug);

					if ( is_array($pay_charge) ) {
						$link		= $pay_charge['data']['link'];
						$expire_at	= $pay_charge['data']['expire_at'];
						$barcode	= $pay_charge['data']['barcode'];
				
						// Cria transação no whmcs "Boleto gerado aguardando pagamento."
						$addtrans = ggnb_add_trans($userID,$invoiceID,$chargeID,$whmcsAdmin, $api_mode, $debug );

					} elseif( is_string($pay_charge) ) {
						$error = $pay_charge;
					}
			
				} else {
						$error = $chargeID;
				}
			
			} elseif ( $invoiceAmount < $minimunAmount ) {
				$error = '<b><span class="ggnberror">O valor total da fatura é R$'.$invoiceAmount.', mas o valor mínimo para pagamento via Boleto que é R$'. $minimunAmount .'.</span></b>';

			}
		
		} // end !$transID
		

		// Resultado impresso na área Visível na fatura/checkout
		if( $error ) {
			// Email enviado ao admin em caso de erro
			if ( $emailonError ) {
				$sendEmailonError = ggnb_send_error_email( $invoiceID, $userID, $firstname, $lastname, $systemUrl, $whmcsAdmin, $emailonError, $error, $debug);
			}
			return $error . $css;
		
		} elseif ( !$error and $redirectToBillet ) {
			header("Location: $link",TRUE,303);
		
		} elseif( !$error ) {

			//////////// Resultado ///////////
			$expire_at_v = strtotime($expire_at);
			$expire_at_br = date('d/m/Y',$expire_at_v);

			$result .= '<a target="_blank" title="Visualizar Boleto" id="ggnbviewbillet" href="'.$link.'">'.$payButton.'</a><br/><br/>';
	
			if ( $discount_tax_value and $discount_tax_visible ) {
				$result .=  $discount_tax_visible_message;
			}
			if ( $showDueDate ) {
				$result .= '<span class="ggnbspan">Vencimento: ' . $expire_at_br . '</span><br/>';
			}
			if ( $showBarCode ) {
				$result .= '<span class="ggnbspan">Linha digitável do boleto:</span><br/><input id="barcode" type="text" size="52" style="font-size: 11px;margin-left: -13px;font-family: arial;" value="'.$barcode.'" disabled><br/>';
			}
			return $result . $css;
		}
	
	}
}

?>