<?php
/**
 * Módulo Gerencinet Boleto para WHMCS
 * @author		Mauricio Gofas | gofas.net
 * @see			https://gofas.net/?p=7893
 * @copyright	2017 https://gofas.net
 * @license		https://www.gnu.org/licenses/gpl-3.0.pt-br.html
 * @support		https://gofas.net/?p=7856
 * @version		1.0.2
 */
 
// Require libraries needed for gateway module functions.
require_once __DIR__ . '/../../../init.php';
require_once __DIR__ . '/../../../includes/gatewayfunctions.php';
require_once __DIR__ . '/../../../includes/invoicefunctions.php';

// Require GN PHP SDK
require __DIR__ . '/sdk/vendor/autoload.php';
use Gerencianet\Exception\GerencianetException;
use Gerencianet\Gerencianet;

// Reporta todos os erros e avisos do php independende da configuração do servidor
error_reporting(E_ERROR | E_WARNING | E_PARSE);

// Puxa parâmetros de configuração do gateway
$params = getGatewayVariables('gofasgerencianetboleto');
	// Debug
	//echo '<pre>';print_r($params);echo '</pre>';
	
// Morre se o módulo está inativo.
if (!$params['type']) {
	die("Module Not Activated");
}

// Recebe o GN token
$token = $_POST['notification'];

if ($token) {

	if( $params['testmode'] ){
		$sandbox		= true;
		$client_id		= $params['clientidsandbox'];
		$client_secret	= $params['clientsecretsandbox'];
		$api_mode		= 'sandbox';

	}
	elseif( !$params['testmode'] ){
		$sandbox		= false;
		$client_id		= $params['clientid'];
		$client_secret	= $params['clientsecret'];
		$api_mode		= 'live';
		
	}
	
	if ( $params['admin'] ) {
		$whmcsAdmin	= $params['admin'];
	}
	else {
		$whmcsAdmin	= 1;
	}
	$fee		= $params['fee'];
	
	

	// Verifica do que se trata a notificação
	$options = [
		'client_id' => $client_id,
		'client_secret' => $client_secret,
		'sandbox' => $sandbox,
	];
 
	$params = [
		'token' => $token
	];
	
	try {
		$api = new Gerencianet($options);
		$notification = $api->getNotification($params, []);

		// Prepara dados retornados
		@$notificationDataEnd	= end($notification['data']);
		$notificationData 		= $notificationDataEnd;
		$invoiceId				= $notificationData['custom_id']; // Captura ID da fatura
		$charge_id				= $notificationData['identifiers']['charge_id']; // Captura ID da transação
		$paymentAmount			= $notificationData['value'] / 100; // Valor da transação
		$previousStatus			= $notificationData['status']['previous']; // Status anterior
		$chargeStatus			= $notificationData['status']['current']; // Status atual
		
		// Debug
		echo 'Notificacao:<br/><pre>';
		print_r($notification);
		echo '</pre>';

		// Consulta dados da fatura
		$getinvoiceid['invoiceid']	= $invoiceId;
		$invoice_data				= localAPI('getinvoice', $getinvoiceid, $whmcsAdmin);

		$invoiceAmount				= $invoice_data['total'];
		$invoiceStatus				= $invoice_data['status'];
		$userID 					= $invoice_data['userid'];

		// Debug
		echo 'Dados da Fatura:<br/><pre>';
		print_r($invoice_data);
		echo '</pre>';

	} catch (GerencianetException $e) {
		die( print_r($e->errorDescription) );

	} catch (Exception $e) {
		die( print_r($e->getMessage()) );
	}
	
	// Confirma pagamento
	if( $chargeStatus === 'paid' and $invoiceStatus === 'Unpaid' ) {
	
 		$addtransvalues['userid']			= $userID;
 		$addtransvalues['invoiceid']		= $invoiceId;
 		$addtransvalues['description']		= 'Boleto pago. Valor recebido: R$'.$paymentAmount;
 		$addtransvalues['amountin']			= $invoiceAmount;
 		if ($fee) {
 			$addtransvalues['fees']			= $fee;
 		} elseif(!$fee) {
 			$addtransvalues['fees']			= '0.00';
 		}
 		$addtransvalues['paymentmethod']	= 'gofasgerencianetboleto';
 		$addtransvalues['transid']			= 'ggnb_'.$api_mode.'_paid-'.$charge_id.'';
 		$addtransvalues['date']				= date('d/m/Y');
		$addtransresult						= localAPI( 'addtransaction' , $addtransvalues, $whmcsAdmin );

		// Debug
		echo 'Resultado:<br/><pre>';
		print_r($addtransresult);
		echo '</pre>';

	}
	
	// Marca como "Não pago" a transação
	if( $chargeStatus === 'unpaid' and $invoiceStatus === 'Unpaid' ) {
		$addtransvalues['userid']			= $userID;
 		$addtransvalues['invoiceid']		= $invoiceId;
 		$addtransvalues['description']		= 'Boleto inadimplente';
 		$addtransvalues['amountin']			= '0.00';
 		$addtransvalues['fees']				= '0.00';
 		$addtransvalues['paymentmethod']	= 'gofasgerencianetboleto';
 		$addtransvalues['transid']			= 'ggnb_'.$api_mode.'_unpaid-'.$charge_id.'';
 		$addtransvalues['date']				= date('d/m/Y');
		$addtransresult						= localAPI( 'addtransaction' , $addtransvalues, $whmcsAdmin );

		// Debug
		echo 'Resultado:<br/><pre>';
		print_r($addtransresult);
		echo '</pre>';
	}
	else {
		die('Notificação ignorada.');
	}
	
} elseif( !$token ) {
	die('Nennhum token válido recebido.');
}