<?php
/**
 * Módulo Gerencinet Boleto para WHMCS
 * @author		Mauricio Gofas | gofas.net
 * @see			https://gofas.net/?p=7893
 * @copyright	2017 https://gofas.net
 * @license		https://www.gnu.org/licenses/gpl-3.0.pt-br.html
 * @support		https://gofas.net/?p=7856
 * @version		1.1.0
 */

// Reporta todos os erros
error_reporting( E_ERROR | E_WARNING | E_PARSE );

if(!defined('WHMCS')) { die('Esse arquivo só pode ser acessado internamente.'); }

function gofasgerencianetboleto_config() {
	return array(
		
		// Nome de exibição amigável para o gateway
		'FriendlyName' => array(
			'Type' => 'System',
			'Value' => 'Gofas Gerencianet - Boleto',
			'Size' => '60',
		),	
		
		/*
		 * Separador 1
		 * Configurações Básicas
		 *
		*/
		'separator_1' => array(
			'Description' => '
			<style type="text/css">
			.ggnb_section {
				background: #dde9f9; padding: 10px 15px 1px;
			}
			.ggnb_separator {
				background: #dde9f9; padding: 1px 15px 1px;
			}
			.ggnb_required {
				color: #CC0000;
				font-size: 20px;
				line-height: 0;
			}
			.ggnb_required_txt {
				color: #CC0000;
			}
			.ggnb_optional_txt {
				color: #02bb04;
			}
			#Payment-Gateway-Config-gofasgerencianetboleto td.fieldlabel {
    			background-color: #fff;
    			text-align: right;
    			vertical-align: text-top;
			}
			#Payment-Gateway-Config-gofasgerencianetboleto td.input-inline {
    			display: inline-block;
    			float: left;
    			clear: left;
			}
			#Payment-Gateway-Config-gofasgerencianetboleto td.fieldarea input {
    			margin-right: 5px;
			}
			</style>
			<div class="ggnb_separator">
				<h4>Configurações Básicas</h4>
				<ul>
					<li>Antes de iniciar a configuração, leia com atenção a <a style="text-decoration: underline;" target="_blank" href="https://gofas.net/?p=7893">documentação do módulo</a>.</li>
				<li>Veja <a style="text-decoration: underline;" target="_blank" href="https://s3.amazonaws.com/uploads.gofas.me/wp-content/uploads/2017/04/API_Gerencianet_Client_ID_Client_Secret_.png">nesta imagem</a> onde criar uma Aplicação e obter as credencians <i>Client_ID</i> e <i>Client _Secret</i> da <a style="text-decoration: underline;" target="_blank" href="https://docs.gerencianet.com.br/">API Gerencianet</a>.</li>
				<li>Asterisco <span class="ggnb_required">*</span> = Campo obrigatório.</li>
			</div>',
		),

		// Client ID
		'clientid' => array(
			'FriendlyName' => 'Client_Id Produção<span class="ggnb_required">*</span>',
			'Type' => 'text',
			'Size' => '60',
			'Default' => '',
			'Description' => '<span class="ggnb_required_txt">(Obrigatório)</span>',
		),
		// Client Secret
		'clientsecret' => array(
			'FriendlyName' => 'Client_Secret Produção<span class="ggnb_required">*</span>',
			'Type' => 'text',
			'Size' => '60',
			'Default' => '',
			'Description' => '<span class="ggnb_required_txt">(Obrigatório)</span>',
		),
		// Client ID Sandbox
		'clientidsandbox' => array(
			'FriendlyName' => 'Client_Id Desenvolvimento<span class="ggnb_required">*</span>',
			'Type' => 'text',
			'Size' => '60',
			'Default' => '',
			'Description' => '<span class="ggnb_required_txt">(Obrigatório)</span>',
		),
		// Client Secret Sandbox
		'clientsecretsandbox' => array(
			'FriendlyName' => 'Client_Secret Desenvolvimento<span class="ggnb_required">*</span>',
			'Type' => 'text',
			'Size' => '60',
			'Default' => '',
			'Description' => '<span class="ggnb_required_txt">(Obrigatório)</span>',
		),
		// Testar?
		'testmode' => array(
			'FriendlyName' => 'Modo de Testes / Sandbox',
			'Type' => 'yesno',
			'Default' => 'yes',
			'Description' => 'Marque essa opção para utilizar a API Gerencianet em modo "Desenvolvimento" (modo de testes). <a style="text-decoration: underline;" href="https://docs.gerencianet.com.br/" target="_blank">Painel da API</a>.',
		),
		// Debug?
		'debugmode' => array(
			'FriendlyName' => 'Modo Diagnóstico / <i>Debug</i>',
			'Type' => 'yesno',
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span> <span class="ggnb_required_txt">Cuidado</span>, marque essa opção para exibir na Fatura os dados "crus" gerados pela API Gerencianet e a API interna do WHMCS.<br/>Use essa funcionalidade apenas para diagnosticar erros. <a title="↗ Gofas.net" style="text-decoration:underline;" target="_blank" href="https://gofas.net/?p=7899">Tutorial para identificar e corrigir erros</a>.</b>',
		),
		
		// whmcs admin
		'admin' => array(
			'FriendlyName' => 'Administrador do WHMCS<span class="ggnb_required">*</span>',
			'Type' => 'text',
			'Size' => '10',
			'Default' => '1',
			'Description' => '<span class="ggnb_required_txt">(Obrigatório)</span> Insira o nome de usuário ou ID do administrador com permissão de uso da API interna do WHMCS.',
		),
		
		// Tarifas
		'fee' => array(
            'FriendlyName'      => 'Valor da tarifa por Boleto',
            'Type'              => 'text',
			'Size' => '10',
            'Description'       => '<span class="ggnb_optional_txt">(Opcional)</span> Insira o valor da comissão paga à Gerencianet a cada Boleto com pagamento confirmado. Essa informação servirá para calcular e preencher o campo "Taxas" (fee) da lista de transações do WHMCS. Use ponto(.) para separar casas decimais, ex.: 1.5',
        ),
		
		// valor mínimo
		'minimunamount' => array(
			'FriendlyName' => 'Valor mínimo do Boleto',
			'Type' => 'text',
			'Size' => '10',
			'Default' => '5',
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span> Insira o valor mínimo da fatura para permitir pagamento via Boleto, 5 equivale à R$ 5,00. O valor mínimo padrão é R$5,00.',
		),
		
		/*
		 * Separador 2
		 * Ações Automatizadas
		 *
		*/
		
		'separator_2' => array(
			'Description' => '
			<div class="ggnb_separator">
				<h4>Ações Automatizadas</h4>
			</div>',
		),
		
		// Altera a data ou cancela e cria um novo boleto
		'cancelbillet' => array(
			'FriendlyName' => 'Cancelar Boleto vencido',
			'Type' => 'yesno',
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span> Cancela o Boleto que já venceu antes de gerar novo Boleto/segunda via. Por padrão, o módulo altera a data de vencimento do Boleto vencido associado à Fatura, quando o cliente acessa a Fatura novamente.',
		),
		
		// Dias + vencimento
		'diasparavencimento' => array(
            'FriendlyName'      => 'Nº de dias para nova data de vencimento de Boletos em atraso',
            'Type'              => 'text',
			'Size' => '10',
            'Description'       => '<span class="ggnb_optional_txt">(Opcional)</span> Número de dias que serão somados a data do vencimento do Boleto ao gerar segunda via ou atualizar um boleto vencido. Essa opção aplica-se apenas a Faturas vencidas, faturas que ainda não venceram sempre irão gerar Boletos com a mesma data de vencimento da Fatura.',
        ),
		
		// Notificar admin sobre erros
		'emailonerror' => array(
			'FriendlyName' => 'Enviar email em caso de erro',
			'Type' => 'text',
			'Size' => '10',
			'Default' => '',
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span> Adicione o ID do departamento de suporte que será notificado em caso de erro nas transações. Deixe em branco para desativar.',
		),
		/*
		 * Separador 3
		 * Campos Personalizados dos Clientes
		 *
		*/
		'separator_3' => array(
			'Description' => '
			<div class="ggnb_separator">
				<h4>Campos Personalizados dos Clientes</h4>
				<p>Antes de configurar as opções a seguir, certifique-se de ter criado e configurado corretamente os <i title="WHMCS > Opções > Campos personaliz. Clientes" style="cursor: help;">Campos Personalizados de Clientes</i> que se aplicam às regras de negócio da sua empresa. Observações importantes:<br>
				<ul>
					<li>Apenas o campo CPF é obrigatório;<br></li>
					<li><b>A Ordem de Exibição</b> dos <i title="WHMCS > Opções > Campos personaliz. Clientes" style="cursor: help;">Campos Personalizados de Clientes</i> <b>é diferente do ID</b> dos Campos Personalizados, <b>nunca</b> adicione o ID dos campos personalizados, <b>sempre</b> o número da Ordem;</li>
					<li>Veja onde encontrar a <a style="text-decoration:underline;" target="_blank" href="https://s3.amazonaws.com/uploads.gofas.me/wp-content/uploads/2017/04/gofas_whmcs_campos_personalizados_clientes.png">"Ordem de Exibição"</a> dos <i title="WHMCS > Opções > Campos personaliz. Clientes" style="cursor: help;">Campos Personalizados de Clientes</i>;</li>
					<li>A Ordem de Exibição dos Campos sempre deve iniciar com 0 (zero).</li>
				</ul>
				</p>
			</div>',
		),
		// customfield CPF
		'customfieldcpf' => array(
			'FriendlyName' => 'Ordem de Exibição do campo CPF/CNPJ<span class="ggnb_required">*</span>',
			'Type' => 'text',
			'Size' => '10',
			'Default' => '0',
			'Description' => '<span class="ggnb_required_txt">(Obrigatório)</span> Insira a Ordem de Exibição do <i title="WHMCS > Opções > Campos personaliz. Clientes" style="cursor: help;">Campo Personalizado de Clientes</i> criado para coletar o CPF do cliente. Esse mesmo campo pode ser utilizado também para coletar o CNPJ do cliente, se o seu whmcs possui apenas um <i>Campo Personalizado de Cliente</i> para CPF e CNPJ.',
		),
		// customfield CNPJ
		'customfieldcnpj' => array(
			'FriendlyName' => 'Ordem de Exibição do campo CNPJ',
			'Type' => 'text',
			'Size' => '10',
			'Default' => '',
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span> Insira a Ordem de Exibição do <i title="WHMCS > Opções > Campos personaliz. Clientes" style="cursor: help;">Campo Personalizado de Clientes</i> criado para coletar apenas o CNPJ do cliente. Deixe em branco se o seu WHMCS possui apenas um campo para CPF e CNPJ. O valor nunca pode ser igual ao da opção anterior.',
		),
		// Exige CPF para PJ?
		'requirecnpjandcpf' => array(
			'FriendlyName' => 'Exigir CPF de Pessoa Jurídica',
			'Type' => 'yesno',
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span> Obriga o envio de CNPJ e CPF para a API Gerencianet. Gera a Transação com o CPF da pessoa física que está concretizando o pagamento + o CNPJ da empresa. <a class="ggnb_required_txt" title="↗ Gofas.net" style="text-decoration:underline;" target="_blank" href="https://gofas.net/?p=8093">Saiba mais sobre essa opção</a>.</b>',
		),
		
		// customfield Desconto - Valor
		'customfielddescontovalor' => array(
			'FriendlyName' => 'Ordem de Exibição do campo "Desconto Personalizado - Valor"',
			'Type' => 'text',
			'Size' => '10',
			'Default' => '',
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span> Insira a Ordem de Exibição do <i title="WHMCS > Opções > Campos personaliz. Clientes" style="cursor: help;">Campo Personalizado de Clientes</i> usado para aplicar descontos personalizados diferentes para clientes específicos. <a style="text-decoration: underline;" target="_blank" href="https://s3.amazonaws.com/uploads.gofas.me/wp-content/uploads/2017/04/WHMCS_-_Campos_Personalizados_dos_Clientes.png">Veja aqui como configurar</a> os <i title="WHMCS > Opções > Campos personaliz. Clientes" style="cursor: help;">Campos Personalizados de Clientes</i> para desconto personalizado.',
		),
		
		// customfield Desconto - Tipo
		'customfielddescontotipo' => array(
			'FriendlyName' => 'Ordem de Exibição "Desconto Personalizado - Tipo de desconto"',
			'Type' => 'text',
			'Size' => '10',
			'Default' => '',
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span> Insira o ID do <i title="WHMCS > Opções > Campos personaliz. Clientes" style="cursor: help;">Campo Personalizado de Clientes</i> que define o tipo de desconto personalizado em R$(Reais) e %(Porcentagem). Use os sinas <b>%</b> e <b>$</b> no nome dos <i title="WHMCS > Opções > Campos personaliz. Clientes" style="cursor: help;">Campos Personalizados de Clientes</i> para diferenciar o tipo de desconto, <a style="text-decoration: underline;" href="https://s3.amazonaws.com/uploads.gofas.me/wp-content/uploads/2017/04/WHMCS_-_Campos_Personalizados_dos_Clientes.png" target="_blank">esta imagem</a> mostra como configurar os campos personalizados de descontos;',
		),
		
		/*
		 * Separador 4
		 * Descontos e Acréscimos
		 *
		*/
		
		'separator_4' => array(
			'Description' => '
			<div class="ggnb_separator">
				<h4>Descontos e Acréscimos</h4>
			</div>',
		),
		
		// Desconto ou taxa
		'descontooutaxa'      => array(
            'FriendlyName'  => 'Desconto ou Taxa adicional',
            'Type'          => 'dropdown',
            'Options'       => array(
                '1'         => 'Desconto',
                '2'         => 'Taxa adicional',
            ),
            'Description'   => '<span class="ggnb_optional_txt">(Opcional)</span> Escolha de deseja oferecer desconto ou acrescentar taxa para pagamentos via Boleto.',
        ),
		// % ou R$
		'tipodescontooutaxa'      => array(
            'FriendlyName'  => 'Tipo de desconto/taxa',
            'Type'          => 'dropdown',
            'Options'       => array(
                '1'         => '% (Porcentagem)',
                '2'         => 'R$ (Reais)',
            ),
            'Description'   => '<span class="ggnb_optional_txt">(Opcional)</span> Escolha se o desconto ou taxa será em Porcentagem ou em Reais',
        ),
		
		// valor do desconto/taxa
		'valordescontooutaxa' => array(
			'FriendlyName' => 'Valor do Desconto ou Taxa',
			'Type' => 'text',
			'Size' => '10',
			'Default' => '',
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span> Valor que será abatido ou acrescentado ao valor total das faturas.',
		),
		
		// dias antes do vencimento para aplicar desconto
		'diasantesvencadddesconto' => array(
			'FriendlyName' => 'Validade do desconto',
			'Type' => 'text',
			'Size' => '10',
			'Default' => '0',
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span> Defina o máximo de dias antes do vencimento para aplicar desconto.<br>
			- Deixe em branco para aplicar desconto mesmo após o vencimento;<br>
			- Insira 0 (zero) para aplicar desconto a Boletos gerados até a data de vencimento da Fatura;<br>
			- Insira de 1 a X, sendo X = <span style="cursor: help;" title="Opções > Configurações Gerais > Configurações de Automação">ao nº de dias antes do vencimento, que as Faturas são geradas</span> para aplicar desconto apenas a Boletos gerados entre 1 e X dias antes da data de vencimento da Fatura.<br> 
			Ao ativar essa opção a data de vencimento do Boleto será igual a data de vencimento da Fatura - (menos) o nº de dias definido nesse campo. Será adicionada a instrução ao caixa "não aceitar pagamento após o vencimento".',
		),
		
		// Exibir informação sobre Desconto / Taxa na fatura
		'exibedescontooutaxa' => array(
			'FriendlyName' => 'Exibir Desconto / Taxa na fatura',
			'Type' => 'yesno',
			'Default' => 'yes',
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span> Assinale se desejar informar sobre o Desconto ou Taxa na fatura.',
		),
		
		// Multa por atraso
		'multa' => array(
			'FriendlyName' => 'Multa após o vencimento',
			'Type' => 'text',
			'Size' => '10',
			'Default' => '',
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span> Multa cobrada após o vencimento (máximo 10%). Use ponto(.) para separar casas decimais, ex.: 1.5',
		),
		// Multa por atraso
		'juros' => array(
			'FriendlyName' => 'Juros após o vencimento',
			'Type' => 'text',
			'Size' => '10',
			'Default' => '',
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span> Juros por dia cobrados após o vencimento (Máximo 0.33%). Use ponto(.) para separar casas decimais.',
		),
		
		/*
		 * Separador 5
		 * Exibição da Fatura e do Boleto
		 *
		*/
		
		'separator_5' => array(
			'Description' => '
			<div class="ggnb_separator">
				<h4>Exibição da Fatura e do Boleto</h4>
			</div>',
		),
		
		// Data de vencimento
		'showduedate' => array(
			'FriendlyName' => 'Exibir data de Vencimento',
			'Type' => 'yesno',
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span> Exibe a data de vencimento do Boleto na fatura, abaixo do botão "visualizar boleto".',
		),
		// Linha digitável
		'showbarcode' => array(
			'FriendlyName' => 'Exibir linha digitável',
			'Type' => 'yesno',
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span> Exibe a linha digitável/código de barras do Boleto, abaixo do botão "visualizar boleto".',
		),
		// Redirecionar para o link do boleto?
		'redirecttobillet' => array(
			'FriendlyName' => 'Redirecionar para o Boleto',
			'Type' => 'yesno',
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span> Redireciona o cliente diretamente para o URL do boleto ao acessar a fatura.',
		),
		
		// Botão "Visualizar boleto"
		'paybutton' => array(
			'FriendlyName' => 'Imagem do botão "Visualizar Boleto"',
			'Type' => 'text',
			'Size' => '90',
			'Default' => '',
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span><br/>Insira o URL da imagem que será usada como botão "Visualizar Boleto" (tamanho recomendado: 160x43px).',
		),
		// Message
		'message' => array(
			'FriendlyName' => 'Mensagem ao cliente',
			'Type' => 'text',
			'Size' => '60',
			'Default' => null,
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span> Inclui no boleto uma mensagem para o cliente (máximo 80 caracteres).',
		),
		/*
		 * Separador 6
		 * Instruções do Boleto
		 *
		*/
		
		'separator_6' => array(
			'Description' => '
			<div class="ggnb_separator">
				<h4>Instruções do Boleto</h4>
				<p>O texto nas linhas de instrução do Boleto devem ser direcionadas ao caixa do banco, nunca para mensagens direcionadas ao cliente, para essa funcionalidade existe o campo acima "Mensagem ao cliente".</p>
				<p>As instruções do Boleto configuradas abaixo serão ignoradas e substituídas pelas instruções padrão da API Gerencianet, quando multa e/ou juros estiverem ativos.</p>
			</div>',
		),
		// Instruções 1
		'instruction1' => array(
			'FriendlyName' => '1ª Instrução do boleto',
			'Type' => 'text',
			'Size' => '60',
			'Default' => 'Após vencimento aceitar pagamento somente no banco emissor.',
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span> Insira a 1ª linha de instruções do Boleto.',
		),
		// Instruções 2
		'instruction2' => array(
			'FriendlyName' => '2ª Instrução do boleto',
			'Type' => 'text',
			'Size' => '60',
			'Default' => 'Não cobrar juros após o vencimento.',
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span> Insira a 2ª linha de instruções do Boleto.',
		),
		// Instruções 3
		'instruction3' => array(
			'FriendlyName' => '3ª Instrução do boleto',
			'Type' => 'text',
			'Size' => '60',
			'Default' => 'Não cobrar multa após o vencimento.',
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span> Insira a 3ª linha de instruções do Boleto.',
		),
		// Instruções 4
		'instruction4' => array(
			'FriendlyName' => '4ª Instrução do boleto',
			'Type' => 'text',
			'Size' => '60',
			'Default' => 'Aceitar apenas pagamento em dinheiro.',
			'Description' => '<span class="ggnb_optional_txt">(Opcional)</span> Insira a 4ª linha de instruções do Boleto.',
		),
		
		'footer' => array(
			'Description' => '<div class="ggnb_section">
			<p>&copy; 2016 - '.date('Y').' <a style="text-decoration:underline;" target="_blank" title="↗ Gofas.net" href="https://gofas.net">Gofas.net</a> | <a style="text-decoration:underline;" target="_blank" title="↗ Gofas.net" href="https://gofas.net/blog/">Versão 1.1.0</a> | <a  style="text-decoration:underline;"target="_blank" title="↗ Documentação" href="https://gofas.net/?p=7893">Documentação</a> | <a style="text-decoration:underline;" target="_blank" title="↗ Fórum de Suporte Gratuito" href="https://gofas.net/?p=7856">Fórum de Suporte Gratuito</a>.</p>
			<p style="font-size: 11px;">
Você está utilizando um software doado gentilmente por nós da <a style="text-decoration:underline;" target="_blank" title="↗ Gofas.net" href="https://gofas.net">Gofas</a> sob a <a style="text-decoration:underline;" target="_blank" href="https://www.gnu.org/licenses/gpl-3.0.en.html">licença GNU 3.0</a>, é importante que você entenda todos os termos e condições de uso do módulo. Criamos esse software com muito amor e ficaremos felizes se ele for útil para o seu negócio, mas <b>não damos nenhuma garantia de funcionamento e/ou suporte</b>. Use, por sua conta e risco.
			<br>
			Se esse módulo é útil para o seu negócio, deixe seu <i>feedback </i> no final da <a style="text-decoration:underline;" target="_blank" href="https://gofas.net/?p=7893">página do módulo</a>.
			<br>
			Para obter ajuda, consulte o <a style="text-decoration:underline;" target="_blank" title="↗ Fórum de Suporte Gratuito" href="https://gofas.net/?p=7856">Fórum de Suporte Gratuito</a> mantido pelos usuários.
			<br>
			Para contratar nossos serviços, <a style="text-decoration:underline;" target="_blank" title="↗ Contratar serviços" href="https://gofas.net/contato/">entre em contato</a>.
			<br>
			Gratidão!
			</p>
			</div>',
		),
	);
}