<?php
/**
 * Módulo Gerencinet Boleto para WHMCS
 * @author		Mauricio Gofas | gofas.net
 * @see			https://gofas.net/?p=7893
 * @copyright	2017 https://gofas.net
 * @license		https://www.gnu.org/licenses/gpl-3.0.pt-br.html
 * @support		https://gofas.net/?p=7856
 * @version		1.1.2
 */
use WHMCS\Database\Capsule; // A partir da versão 1.1.2
if(!defined('WHMCS')) { die('Esse arquivo não pode ser acessado diretamente'); }

// Debug
if ($debug) {
	echo '<pre style="height:300px;" class="debug">';
	echo '<h4 class="ok">Você está vendo essas informações na tela por quê a opção "debug" do módulo <b>Gofas Gerencianet Boleto</b> está ativa.</h4>';
	echo '<p>Operações bem sucedidas possuem títulos <span class="ok">verdes</span> e erros são destacados em <span class="erro">vermelho</span></p>';
	echo '<p>Saiba mais sobre como diagnosticar erros e coletar informações para suporte <a target="_blank" href="https://gofas.net/?p=7899&rf=ggnbfatura">neste link</a></p>';
	echo '<p>Veja várias soluções para dificuldades comuns no <a href="https://gofas.net/forums/forum/whmcs/modulo-gerencianet-boleto-para-whmcs/?rf=ggnbfatura" target="_blank">fórum de suporte do módulo</a>.</p>';
		
	echo '<p class="ok">Todas as configurações do módulo</p>';
	print_r( $params );
	echo '<br>';
	
	// Debug fatura
	echo '<p class="ok">Resultado da consulta por informações da fatura (API interna - WHMCS).</p>';
	print_r($GetInvoiceResults);
	echo '<br>';

	echo '<p class="ok">Transações registradas por esta fatura - API WHMCS.</p><br/>';
	if ($transID) {
		echo 'Transação existente: '.$transID;
	}
	else {
		echo 'Nenhuma transação registrada.';
	}
	echo '<br>';

	// Debug de juros e multa
	if ( $fine || $interest ) {
	
		echo '<p class="ok">Configurações de juros e multa</p><br/>';
		print_r($configurations);
		echo '<br/>';
		echo 'Multa de ' .$params['multa'].'% equivale a fine = '. $fine . '<br/>';
		echo 'Juros de ' .$params['juros'].'% equivale a interest = '. $interest . '<br/>';
		echo '<br>';
	}

	// Debug Desconto Personalizado
	if ( $custom_discount ) {
		echo '<p class="ok">Desconto personalizado específico do cliente associado à essa Fatura</p>';
		if ($custom_discount_type ) {
			echo 'Tipo de desconto: ', $custom_discount_type, '<br>';
		}
		if ( $custom_discount ) {
			echo 'Valor do desconto: ', $custom_discount, '<br>';
		}
		echo '<br>';
	}


	echo '<p class="ok">Produtos/serviços da fatura - API WHMCS.</p>';
	echo '<p class="ok">Itens com valor negativo:</p>';
	print_r($disc_item);
	
	echo '<p class="ok">Itens da Fatura:</p>';
	print_r( $item );
	echo '<br/>';
	
	echo '<p class="ok">Soma dos itens com valor negativo:</p>';
	echo '$discount_item: ', $discount_item, '<br>';
	echo '$whmcs_discount: ', $whmcs_discount, '<br>';
	
	echo '<p class="ok">Desconto válido até:</p>';
	echo $discount_valid_until, ' | ', $days_for_discount, ' dias antes do vencimento<br>';

	echo '<p class="ok">Cálculos.</p>';
	echo 'Hoje: ', $today, '<br/>';
	echo 'Vencimento: ', $due_date, '<br/>';
	echo 'Diferença entre datas: ', $due_days, ' dia(s)<br/>';
	echo 'Multa: ' , $fine_value, '<br/>';
	echo 'Juros: ' , $interest_value, '<br/>';
	echo 'Valor original * 100: ' , $VALUE * 100, '<br/>';
	echo 'Total: ' , $new_value, '<br/>';
	
	// Dados do cliente
	foreach ( Capsule::table('tblclients')  -> where('id', $userID) -> get() as $client) { 
    	$client_email	= $client->email;
		$client_id		= $client->id;
		$first_name		= $client->firstname;
		$last_name		= $client->lastname;
	}
	//$getClientValues['clientid']		= $userID;
	//$getClientValues['stats']			= false;
	//$getClientValues['responsetype']	= 'json';
	//$getClientResults					= localAPI('getclientsdetails',$getClientValues,$whmcsAdmin);
	echo '<p class="ok">Dados do cliente - API WHMCS.</p>';
	print_r($client);
	echo '<br/>';

	echo '<p class="ok">Dados do cliente enviados à GN API</p>';
	echo 'cpf: ' . $cpf ;
	echo '<br/>cnpj: ' . $cnpj ;
	echo '<br/>$customer: ';
	print_r($customer);
	echo '<br/>$juridical_data:<br/>';
	print_r($juridical_data);
	echo '</pre>';
	
	// Debug Functions
	
	
}