<?php
if (!defined("WHMCS"))
	die("Este arquivo n&atilde;o pode ser acessado via URL.");

function income_overview_bars($vars) {
    global $_ADMINLANG,$chart,$currency;
    $currency = getCurrency();

    $months = array('JAN','FEV','MAR','ABR','MAI','JUN','JUL','AGO','SET','OUT','NOV','DEZ');
    if (!$year) $year = date("Y");
	$title = 'Vis&atilde;o Geral - Renda '.$year;

    for ( $counter = 1; $counter <= 12; $counter += 1) {
	$month = $months[$counter-1];
	$counter = str_pad($counter, 2, "0", STR_PAD_LEFT);
        $data = get_query_vals("tblaccounts","SUM(amountin/rate),SUM(fees/rate),SUM(amountout/rate)","date LIKE '$year-$counter-%'");
	$amountin = $data[0];
	$fees = $data[1];
	$amountout = $data[2];
	$monthlybalance = $amountin-$fees-$amountout;
	$overallbalance += $monthlybalance;
        $prevyearbal = get_query_val("tblaccounts","SUM((amountin-fees-amountout)/rate)","date LIKE '".($year-1)."-$counter-%'");
        $prevyearbal = round($prevyearbal,2);
        $chartdata['rows'][] = array('c'=>array(array('v'=>$month),array('v'=>$prevyearbal,'f'=>formatCurrency($prevyearbal)),array('v'=>$monthlybalance,'f'=>formatCurrency($monthlybalance))));
    	$amountin = formatCurrency($amountin);
    	$fees = formatCurrency($fees);
    	$amountout = formatCurrency($amountout);
    	$monthlybalance = formatCurrency($monthlybalance);
    }


$chartdata['cols'][] = array('label'=>'Days Range','type'=>'string');
$chartdata['cols'][] = array('label'=>$year-1,'type'=>'number');
$chartdata['cols'][] = array('label'=>$year,'type'=>'number');

$args = array();
$args['colors'] = '#F9D88C,#3070CF';
$args['chartarea'] = '80,40,85%,70%';
$args['ylabel'] = 'Total Renda';
$args['xlabel'] = 'Meses';

    $content = $chart->drawChart('Column',$chartdata,$args,'300px');

    return array( 'title' => $title, 'content' => $content );
 
}
 
add_hook("AdminHomeWidgets",1,"income_overview_bars");
 
?>
